/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rcs.CommManager;
import com.ibm.hwmca.fw.rcs.PathQueueListener;
import com.ibm.hwmca.fw.rcs.RcsCallbackSegment;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathEvent;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathManager
implements ShutdownListener {
    private static final String TRACE_MASKT = "XRCSMGRT";
    private static final String TRACE_MASKF = "XRCSMGRF";
    private static final String TRACE_MASKD = "XRCSMGRD";
    private static PathManager instance;
    protected Set activePaths;
    protected Set waitingPaths;
    protected Set readyPaths;
    private static final long TIMEOUT = 10000L;
    protected Map paths;
    private Object threadLock = new Object();
    private Object dataLock = new Object();
    protected RcsLink activeLink = null;
    protected boolean queueOnHold = false;
    private boolean shutdown = false;
    protected List listeners;
    private static Object getLock;
    private static final FrameworkClassLogInfo classLogInfo;
    private int sdc;
    public static final int SDC_PRIMARY = 1;
    public static final int SDC_SECONDARY = 2;
    private static boolean rsCall;
    int failedReturnCode = 0;

    private PathManager() {
        Trace.trace(TRACE_MASKT, "--> PathManager()");
        Queue.highPriority = new LinkedList();
        Queue.lowPriority = new LinkedList();
        this.activePaths = new HashSet();
        this.readyPaths = new HashSet();
        this.waitingPaths = new HashSet();
        this.paths = new HashMap();
        this.listeners = new ArrayList();
        this.sdc = 1;
        new Thread(){

            public void run() {
                this.setName("PathManager worker thread.");
                PathManager.this.managePaths();
            }
        }.start();
        ShutdownManager.getShutdownManager().addShutdownListener(this);
        Trace.trace(TRACE_MASKT, "<-- PathManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathManager getPathManager() {
        Object object = getLock;
        synchronized (object) {
            if (instance == null) {
                instance = new PathManager();
            }
        }
        Trace.trace(TRACE_MASKT, "<-> getPathManager() [" + instance + "]");
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void managePaths() {
        Object pathId;
        Iterator i;
        Trace.trace(TRACE_MASKT, "--> managePaths()");
        CommManager.getCommManager();
        this.initRcsControl();
        RcsCallbackSegment.run();
        Object object = this.threadLock;
        // MONITORENTER : object
        while (!this.shutdown) {
            try {
                Object pathId2;
                if (!this.waitingPaths.isEmpty()) {
                    Trace.trace(TRACE_MASKD, "  ] paths are waiting for a link to open");
                    if (this.activeLink != null && this.activeLink.isActive()) {
                        Trace.trace(TRACE_MASKD, "  ] active link to utilize");
                        Object object2 = this.dataLock;
                        // MONITORENTER : object2
                        i = this.waitingPaths.iterator();
                        while (i.hasNext()) {
                            pathId = (PathIdentifier)i.next();
                            RcsPath path = (RcsPath)this.paths.get(pathId);
                            if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) continue;
                            i.remove();
                            this.activePaths.add(pathId);
                            path.sendEvent(PathEvent.OPENED);
                        }
                        // MONITOREXIT : object2
                    } else {
                        this.activeLink = null;
                        pathId2 = null;
                        RcsPath path = null;
                        pathId = this.dataLock;
                        // MONITORENTER : pathId
                        Iterator i2 = this.waitingPaths.iterator();
                        if (i2.hasNext()) {
                            pathId2 = (PathIdentifier)i2.next();
                            path = (RcsPath)this.paths.get(pathId2);
                        }
                        // MONITOREXIT : pathId
                        if (pathId2 != null) {
                            Trace.trace(TRACE_MASKD, "  ] no active link but there is a path waiting");
                            List links = path.getSupportedLinkTypes();
                            boolean nothingWasConfigured = true;
                            if (links != null) {
                                Iterator li = links.iterator();
                                while (li.hasNext()) {
                                    Class linkClass = (Class)li.next();
                                    Trace.trace(TRACE_MASKD, "  ] attempting to use " + linkClass);
                                    try {
                                        Method method = linkClass.getMethod("getInstance", null);
                                        RcsLink link = (RcsLink)method.invoke(null, null);
                                        link.setPath(path);
                                        method = linkClass.getMethod("isConfigured", null);
                                        boolean configured = (Boolean)method.invoke((Object)link, null);
                                        if (!configured) continue;
                                        nothingWasConfigured = false;
                                        method = linkClass.getMethod("activate", null);
                                        method.invoke((Object)link, null);
                                        this.activeLink = link;
                                        Trace.trace(TRACE_MASKD, "  ] " + linkClass + " was successfully activated");
                                        Object object3 = this.dataLock;
                                        // MONITORENTER : object3
                                        if (this.waitingPaths.remove(pathId2)) {
                                            this.activePaths.add(pathId2);
                                        }
                                        // MONITOREXIT : object3
                                        path.sendEvent(PathEvent.OPENED);
                                        break;
                                    }
                                    catch (InvocationTargetException invokeException) {
                                        Throwable e = invokeException.getCause();
                                        if (e == null) continue;
                                        if (e instanceof LinkAlreadyActiveException) {
                                            Trace.trace(TRACE_MASKD, "Warning: LinkAlreadyActiveException");
                                            continue;
                                        }
                                        if (e instanceof LinkFailedException) {
                                            this.failedReturnCode = ((LinkFailedException)e).getReturnCode();
                                            Trace.trace(TRACE_MASKD, "Warning: LinkFailedException");
                                            this.logException(new HException(e));
                                            continue;
                                        }
                                        if (e instanceof LinkNotConfiguredException) {
                                            Trace.trace(TRACE_MASKD, "Warning: LinkNotConfiguredException");
                                            continue;
                                        }
                                        Trace.trace(TRACE_MASKD, "Error: Unexpected Exception (" + e + ")");
                                        this.logException(new HException(e));
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKD, "Error: Unexpected Exception (" + e + ")");
                                        this.logException(e);
                                    }
                                }
                                if (this.activeLink == null) {
                                    this.cancelPath((PathIdentifier)pathId2, PathCancelReason.LINK);
                                    if (nothingWasConfigured) {
                                        Trace.trace(TRACE_MASKD, "Warning: no links were configured");
                                    } else {
                                        Trace.trace(TRACE_MASKD, "Error: all links failed to connect");
                                        this.logException(new HException("ALL LINKS FAILED TO CONNECT"));
                                    }
                                }
                            }
                        }
                    }
                }
                if (this.activeLink != null && this.activeLink.isActive()) {
                    Trace.trace(TRACE_MASKD, "  ] there is an active link");
                    if (!this.queueOnHold) {
                        pathId2 = this.dataLock;
                        // MONITORENTER : pathId2
                        i = Queue.highPriority.iterator();
                        while (this.waitingPaths.size() + this.readyPaths.size() + this.activePaths.size() < this.activeLink.getMaxOpenPaths() && i.hasNext()) {
                            Trace.trace(TRACE_MASKD, "  ] queued high priority paths");
                            pathId = (PathIdentifier)i.next();
                            RcsPath path = (RcsPath)this.paths.get(pathId);
                            if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) continue;
                            i.remove();
                            Trace.trace(TRACE_MASKD, "adding " + pathId + " to readyPaths");
                            this.readyPaths.add(pathId);
                            path.sendEvent(PathEvent.READY);
                        }
                        // MONITOREXIT : pathId2
                        pathId2 = this.dataLock;
                        // MONITORENTER : pathId2
                        if (!Queue.lowPriority.isEmpty()) {
                            Trace.trace(TRACE_MASKD, "  ] queued low priority paths");
                            Trace.trace(TRACE_MASKD, "waitingPaths.size() = " + this.waitingPaths.size());
                            Trace.trace(TRACE_MASKD, "readyPaths.size() = " + this.readyPaths.size());
                            Trace.trace(TRACE_MASKD, "activePaths.size() = " + this.activePaths.size());
                            i = Queue.lowPriority.iterator();
                            while (this.waitingPaths.size() + this.readyPaths.size() + this.activePaths.size() < this.activeLink.getMaxOpenPaths() && i.hasNext()) {
                                pathId = (PathIdentifier)i.next();
                                RcsPath path = (RcsPath)this.paths.get(pathId);
                                Trace.trace(TRACE_MASKD, "checking " + pathId + " to see if it can utilize this connection");
                                if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) break;
                                i.remove();
                                Trace.trace(TRACE_MASKD, "adding " + pathId + " to readyPaths");
                                this.readyPaths.add(pathId);
                                path.sendEvent(PathEvent.READY);
                            }
                        }
                        // MONITOREXIT : pathId2
                    }
                    if (this.activePaths.isEmpty() && this.readyPaths.isEmpty()) {
                        Trace.trace(TRACE_MASKD, "  ] nothing active, deactivating link");
                        this.activeLink.deactivate();
                        this.activeLink = null;
                    } else {
                        Trace.trace(TRACE_MASKD, "  ] currently active paths" + this.activePaths + " | " + this.readyPaths);
                    }
                }
                if (this.activeLink == null || !this.activeLink.isActive()) {
                    this.activeLink = null;
                    pathId2 = this.dataLock;
                    // MONITORENTER : pathId2
                    if (!this.activePaths.isEmpty()) {
                        Trace.trace(TRACE_MASKD, "  ] active paths is not empty (bad)");
                        i = this.activePaths.iterator();
                        while (i.hasNext()) {
                            pathId = (PathIdentifier)i.next();
                            this.cancelPath((PathIdentifier)pathId, PathCancelReason.LINK);
                        }
                    }
                    // MONITOREXIT : pathId2
                    pathId2 = this.dataLock;
                    // MONITORENTER : pathId2
                    if (this.readyPaths.isEmpty() && this.waitingPaths.isEmpty() && !this.queueOnHold) {
                        PathIdentifier pathId3;
                        if (!Queue.highPriority.isEmpty()) {
                            pathId3 = (PathIdentifier)Queue.highPriority.remove(0);
                            Trace.trace(TRACE_MASKD, "adding " + pathId3 + " to readyPaths");
                            this.readyPaths.add(pathId3);
                            ((RcsPath)this.paths.get(pathId3)).sendEvent(PathEvent.READY);
                        } else if (!Queue.lowPriority.isEmpty()) {
                            pathId3 = (PathIdentifier)Queue.lowPriority.remove(0);
                            Trace.trace(TRACE_MASKD, "adding " + pathId3 + " to readyPaths");
                            this.readyPaths.add(pathId3);
                            ((RcsPath)this.paths.get(pathId3)).sendEvent(PathEvent.READY);
                        }
                    }
                    // MONITOREXIT : pathId2
                }
                try {
                    this.threadLock.wait(10000L);
                }
                catch (Exception e) {
                    this.logException(e);
                }
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        ArrayList allPaths = new ArrayList();
        allPaths.addAll(Queue.highPriority);
        allPaths.addAll(Queue.lowPriority);
        allPaths.addAll(this.readyPaths);
        allPaths.addAll(this.waitingPaths);
        allPaths.addAll(this.activePaths);
        i = allPaths.iterator();
        while (true) {
            if (!i.hasNext()) {
                this.stopRcsControl();
                // MONITOREXIT : object
                Trace.trace(TRACE_MASKT, "<-- managePaths()");
                return;
            }
            pathId = (PathIdentifier)i.next();
            this.cancelPath((PathIdentifier)pathId, PathCancelReason.SHUTDOWN);
        }
    }

    private void logException(Exception e) {
        ByteArrayOutputStream exDump = new ByteArrayOutputStream(1024);
        e.printStackTrace(new PrintStream(exDump));
        Trace.trace(TRACE_MASKF, "Exception: " + exDump.toString());
        FrameworkLog fl = new FrameworkLog(classLogInfo, 1942);
        fl.add("EXCEPTION CAUGHT: " + exDump);
        fl.log(FrameworkLogAttributes.INFO_LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActivePaths() {
        Trace.trace(TRACE_MASKT, "--> getActivePaths()");
        ArrayList paths = new ArrayList();
        Object object = this.dataLock;
        synchronized (object) {
            paths.addAll(this.activePaths);
            paths.addAll(this.waitingPaths);
        }
        Trace.trace(TRACE_MASKT, "<-- getActivePaths() [" + paths + "]");
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(RcsPath path) throws NullPointerException {
        Trace.trace(TRACE_MASKT, "--> addPath( " + path + " )");
        if (path == null) {
            throw new NullPointerException();
        }
        Object object = this.dataLock;
        synchronized (object) {
            PathIdentifier pathId = path.getPathIdentifier();
            int position = 0;
            this.paths.put(pathId, path);
            if (path.getPriority() == PathPriority.LOW) {
                Queue.lowPriority.add(pathId);
                position = Queue.lowPriority.indexOf(pathId);
            } else if (path.getPriority() == PathPriority.HIGH) {
                Queue.highPriority.add(pathId);
            }
            Iterator listenIt = this.listeners.iterator();
            while (listenIt.hasNext()) {
                ((PathQueueListener)listenIt.next()).addedToWaiting(pathId, position);
            }
            Trace.trace(TRACE_MASKD, "  ] notify worker thread...");
        }
        Trace.trace(TRACE_MASKT, "<-- addPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPath(PathIdentifier pathId, PathCancelReason reason) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> cancelPath( " + pathId + ", " + reason + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                path.sendEvent(PathEvent.CANCELLED, reason);
                try {
                    this.closePath(pathId);
                }
                catch (IllegalArgumentException e) {
                    Trace.trace(TRACE_MASKF, "Swallowing IllegalArgumentException since path has already been closed");
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- cancelPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPath(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> openPath( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                if (!this.readyPaths.contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                this.readyPaths.remove(pathId);
                this.waitingPaths.add(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).moveFromWaitingToActive(pathId);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- openPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePath(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> closePath( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                boolean wasActive = false;
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                if (this.activePaths.remove(pathId)) {
                    wasActive = true;
                }
                if (this.waitingPaths.remove(pathId)) {
                    wasActive = true;
                }
                this.readyPaths.remove(pathId);
                Queue.highPriority.remove(pathId);
                Queue.lowPriority.remove(pathId);
                this.paths.remove(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    if (wasActive) {
                        ((PathQueueListener)listenIt.next()).removedFromActive(pathId);
                        continue;
                    }
                    ((PathQueueListener)listenIt.next()).removedFromWaiting(pathId);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- closePath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueuedPaths() {
        Trace.trace(TRACE_MASKT, "--> getQueuedPaths()");
        ArrayList queue = new ArrayList();
        Object object = this.dataLock;
        synchronized (object) {
            queue.addAll(this.readyPaths);
            queue.addAll(Queue.highPriority);
            queue.addAll(Queue.lowPriority);
        }
        Trace.trace(TRACE_MASKT, "<-- getQueuedPaths() [" + queue + "]");
        return queue;
    }

    public void setPriority(PathIdentifier pathId, PathPriority priority) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> setPriority( " + pathId + ", " + priority + " )");
        Trace.trace(TRACE_MASKT, "<-- setPriority()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathNext(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> setPathNext( " + pathId + " )");
        Object object = this.dataLock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                if (Queue.lowPriority.remove(pathId)) {
                    Queue.highPriority.add(0, pathId);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- setPathNext()");
    }

    public boolean failLink() {
        if (this.activeLink == null) {
            Trace.trace(TRACE_MASKT, "<-> failLink() [false]");
            return false;
        }
        boolean fail = this.activeLink.fail();
        Trace.trace(TRACE_MASKT, "<-> failLink() [" + fail + "]");
        return fail;
    }

    public InetAddress getLinkAddress() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        InetAddress ip = this.activeLink.getAddress();
        Trace.trace(TRACE_MASKT, "<-> getLinkAddress() [" + ip + "]");
        return ip;
    }

    public boolean isHighPerformanceLink() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        boolean hpl = this.activeLink.isHighPerformanceLink();
        Trace.trace(TRACE_MASKT, "<-> isHighPerformanceLink() [" + hpl + "]");
        return hpl;
    }

    private void initRcsControl() {
        RcsControl.init();
    }

    private void stopRcsControl() {
        RcsControl.quit();
    }

    public void shutdownStarting(ShutdownRequest request, long delay) {
        Trace.trace(TRACE_MASKT, "--> shutdownStarting( " + request + ", " + delay + " )");
        this.shutdown = true;
        Trace.trace(TRACE_MASKT, "<-- shutdownStarting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] addPathQueueListener(PathQueueListener listener) throws NullPointerException {
        Trace.trace(TRACE_MASKT, "--> addPathQueueListener(" + listener + ")");
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        List[] queues = null;
        Object object = this.dataLock;
        synchronized (object) {
            this.listeners.add(listener);
            queues = new List[]{this.getActivePaths(), this.getQueuedPaths()};
        }
        Trace.trace(TRACE_MASKT, "<-- addPathQueueListener() [" + queues + "]");
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathQueueListener(PathQueueListener listener) {
        Trace.trace(TRACE_MASKT, "--> removePathQueueListener(" + listener + ")");
        Object object = this.dataLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- removePathQueueListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueOnHold(boolean value) {
        Trace.trace(TRACE_MASKT, "--> setQueueOnHold(" + value + ")");
        Object object = this.dataLock;
        synchronized (object) {
            if (this.queueOnHold != value) {
                this.queueOnHold = value;
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).queueStateChanged(value);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<-- setQueueOnHold()");
    }

    public boolean isQueueOnHold() {
        Trace.trace(TRACE_MASKT, "<-> isQueueOnHold() [" + this.queueOnHold + "]");
        return this.queueOnHold;
    }

    public void setSdc(int sdc) {
        Trace.trace(TRACE_MASKT, "<-> setSdc( " + sdc + " )");
        this.sdc = sdc;
    }

    public int getSdc() {
        Trace.trace(TRACE_MASKT, "<-> getSdc() [" + this.sdc + "]");
        return this.sdc;
    }

    public boolean isRemoteServiceCall() {
        return false;
    }

    public void setRemoteServiceCall(boolean b) {
        rsCall = b;
    }

    public int getReturnCode() {
        return this.failedReturnCode;
    }

    static {
        getLock = new Object();
        classLogInfo = new FrameworkClassLogInfo(85, "RCS-PATHMNGR");
        rsCall = false;
    }

    protected static class Queue {
        public static List highPriority;
        public static List lowPriority;

        protected Queue() {
        }
    }

    public static class Init
    implements Runnable {
        public void run() {
            Trace.trace(PathManager.TRACE_MASKT, "--> Init.run()");
            PathManager.getPathManager();
            Trace.trace(PathManager.TRACE_MASKT, "<-- Init.run()");
        }
    }
}

